package coreservlets.listeners;

import javax.servlet.*;
import javax.servlet.http.*;

/** Proces nasuchujcy zlicza sesje
 *  aktualnie uywane w aplikacji internetowej
 *  oraz kiedykolwiek uywane w cyklu ycia aplikacji.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class SessionCounter implements HttpSessionListener {
  private int totalSessionCount = 0;
  private int currentSessionCount = 0;
  private int maxSessionCount = 0;
  private ServletContext context = null;
  
  public void sessionCreated(HttpSessionEvent event) {
    totalSessionCount++;
    currentSessionCount++;
    if (currentSessionCount > maxSessionCount) {
      maxSessionCount = currentSessionCount;
    }
    if (context == null) {
      storeInServletContext(event);
    }
  }

  public void sessionDestroyed(HttpSessionEvent event) {
    currentSessionCount--;
  }

  /** Cakowita liczba utworzonych sesji. */
  public int getTotalSessionCount() {
    return(totalSessionCount);
  }

  /** Liczba sesji aktualnie znajdujcych si w pamici. */
  public int getCurrentSessionCount() {
    return(currentSessionCount);
  }

  /** Najwiksza liczba sesji kiedykolwiek znajdujcych
   *  si w pamici w jednym momencie.
   */
  public int getMaxSessionCount() {
    return(maxSessionCount);
  }

  /** Zarejestrowanie si w kontekcie serwletu,
   *  aby serwlety i strony JSP miay dostp do licznikw sesji.
   */
  private void storeInServletContext(HttpSessionEvent event) {
    HttpSession session = event.getSession();
    context = session.getServletContext();
    context.setAttribute("sessionCounter", this);
  }
}
